#!/bin/sh

TP_DHCP_OR_STATIC_RESULT_STATIC="$DTAS[TUI]@{STATIC}"
TP_DHCP_OR_STATIC_RESULT_DHCP="$DTAS[TUI]@{DHCP}"
TP_DHCP_OR_STATIC_RESULT_NULL="DTAS[TUI]@{NULL}"
TP_DHCP_OR_STATIC_RESULT_SELECT=""

TP_DHCP_OR_STATIC_RESULT_OK="DTAS[TUI]@{OK}"
TP_DHCP_OR_STATIC_RESULT_CANCEL="DTAS[TUI]@{CANCEL}"
TP_DHCP_OR_STATIC_RESULT_ERROR="DTAS[TUI]@{ERROR}"
TP_DHCP_OR_STATIC_RESULT_CODE=""

TP_DHCP_OR_STATIC_RESULT_MSG=""

tp_dhcp_or_static() {
	debug_print "${0}" "${LINENO}" 'in function "tp_dhcp_or_static"'

	local title="${1}"
	local text="${2}"
	local label_ok="${3}"
	local label_cancel="${4}"

    exec 3>&1
    local ret=`dialog \
        --backtitle    "${CONS_BACK_TITLE}" \
        --title        "${title}" \
        --ok-label     "${label_ok}" \
        --cancel-label "${label_cancel}" \
        --radiolist    "${text}" \
                       "18" \
                       "${CONS_BOX_WIDTH}" \
                       0 \
                       "${STRING_USE_STATIC_IP}" "" on  \
                       "${STRING_USE_DHCP}"      "" off \
        2>&1 1>&3; \
        case "${?}" in \
            1|255) echo "${TP_DHCP_OR_STATIC_RESULT_CANCEL}" ; return ;;
        esac`
    exec 3>&-
    
    debug_print "${0}" "${LINENO}" "Ret: ${ret}"
    case "${ret}" in
        "${STRING_USE_STATIC_IP}")
            TP_DHCP_OR_STATIC_RESULT_CODE="${TP_DHCP_OR_STATIC_RESULT_OK}"
            TP_DHCP_OR_STATIC_RESULT_SELECT="${TP_DHCP_OR_STATIC_RESULT_STATIC}"
            TP_DHCP_OR_STATIC_RESULT_MSG=""
            ;;
        
        "${STRING_USE_DHCP}")
            TP_DHCP_OR_STATIC_RESULT_CODE="${TP_DHCP_OR_STATIC_RESULT_OK}"
            TP_DHCP_OR_STATIC_RESULT_SELECT="${TP_DHCP_OR_STATIC_RESULT_DHCP}"
            TP_DHCP_OR_STATIC_RESULT_MSG=""
            ;;

        # press CANCEL or ESC
        "${TP_DHCP_OR_STATIC_RESULT_CANCEL}") 
            TP_DHCP_OR_STATIC_RESULT_CODE="${TP_DHCP_OR_STATIC_RESULT_CANCEL}"
            TP_DHCP_OR_STATIC_RESULT_SELECT="${TP_DHCP_OR_STATIC_RESULT_NULL}"
            TP_DHCP_OR_STATIC_RESULT_MSG=""
            ;;

        *)
            debug_print "${0}" "${LINENO}" "Ret: ${ret}"
            TP_DHCP_OR_STATIC_RESULT_CODE="${TP_DHCP_OR_STATIC_RESULT_ERROR}"
            TP_DHCP_OR_STATIC_RESULT_SELECT="${TP_DHCP_OR_STATIC_RESULT_NULL}"
            TP_DHCP_OR_STATIC_RESULT_MSG="Ret: ${ret}"
            ;;
    esac
}
